// single_list.h
#ifndef CA_UWATERLOO_DWHARDER_SINGLE_LIST
#define CA_UWATERLOO_DWHARDER_SINGLE_LIST

// Include directives
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

// Structure definitions
typedef struct single_node {
	void *p_entry;
	struct single_node *p_next;
} single_node_t;

typedef struct {
	single_node_t *p_head;
	single_node_t *p_tail;
	size_t size;
	single_node_t *p_node_pool;
	size_t capacity;
	uint64_t version;
} single_list_t;

// Function declarations
void single_node_init( single_node_t *const p_this,
                       void *p_new_entry,
                       single_node_t *p_new_next );

void single_list_init( single_list_t *const p_this,
                       single_node_t *p_new_single_list_entries,
                       size_t new_single_list_capacity );

void *single_list_front( single_list_t *const p_this );
void *single_list_back( single_list_t *const p_this );
bool  single_list_push_front( single_list_t *const p_this, void *p_new_entry );
bool  single_list_push_back( single_list_t *const p_this, void *p_new_entry );
void *single_list_pop_front( single_list_t *const p_this );
void  single_list_clear( single_list_t *const p_this );

// Macro definitions
#define single_list_empty( p_this ) ((p_this)->size == 0)
#define single_list_size( p_this ) ((p_this)->size + 0)
#define single_list_full( p_this ) ((p_this)->size == (p_this)->capacity)
#define single_list_capacity( p_this ) ((p_this)->capacity + 0)
#define single_list_version( p_this ) ((p_this)->version + 0)
#endif
