// single_list.c
#include "single_list.h"
#include <assert.h>
void single_node_init( single_node_t *const p_this,
	void *p_new_entry,
	single_node_t *p_new_next ) {
	p_this->p_entry = p_new_entry;
	p_this->p_next = p_new_next;
}

void single_list_init( single_list_t *const p_this,
	single_node_t *p_new_single_list_entries,
	size_t new_single_list_capacity ) {
	p_this->p_head = NULL;
	p_this->p_tail = NULL;
	p_this->size = 0;
	p_this->p_node_pool = p_new_single_list_entries;
	p_this->capacity = new_single_list_capacity;

	// Place all the nodes in the array onto a 'free list' where each node
	// points to the next in the list and the last node points to NULL.
	size_t i;
	single_node_t *p_node_itr = p_this->p_node_pool;

	for ( i = 0; i < new_single_list_capacity - 1; ++i ) {
		p_node_itr->p_next = p_node_itr + 1;
		++( p_node_itr );
	}

	p_node_itr->p_next = NULL;
	p_this->version = 0;
}

void *single_list_front( single_list_t *const p_this ) {
	void *p_front_entry = NULL;

	if ( single_list_empty( p_this ) ) {
		// p_front_entry = NULL;
	} else {
		p_front_entry = p_this->p_head->p_entry;
	}

	return p_front_entry;
}

void *single_list_back( single_list_t *const p_this ) {
	void *p_back_entry = NULL;

	if ( single_list_empty( p_this ) ) {
		// p_back_entry = NULL;
	} else {
		p_back_entry = p_this->p_tail->p_entry;
	}

	return p_back_entry;
}

bool single_list_push_front( single_list_t *const p_this, void *p_new_entry ) {
	bool success = false;

	if ( single_list_full( p_this ) ) {
		// success = false;
	} else {
		success = true;
		// Pop a node off of the free list
		single_node_t *p_new_node = p_this->p_node_pool;
		p_this->p_node_pool = p_this->p_node_pool->p_next;
		single_node_init( p_new_node, p_new_entry, p_this->p_head );
		p_this->p_head = p_new_node;

		if ( single_list_empty( p_this ) ) {
			p_this->p_tail = p_new_node;
		}

		++( p_this->size );
		++( p_this->version );
	}

	return success;
}

bool single_list_push_back( single_list_t *const p_this, void *p_new_entry ) {
	assert( p_new_entry != NULL );
	bool success = false;

	if ( single_list_full( p_this ) ) {
		// success = false;
	} else {
		success = true;
		single_node_t *p_new_node = p_this->p_node_pool;
		p_this->p_node_pool = p_this->p_node_pool->p_next;
		p_new_node->p_entry = p_new_entry;
		p_new_node->p_next = NULL;

		if ( single_list_empty( p_this ) ) {
			p_this->p_head = p_new_node;
		} else {
			p_this->p_tail->p_next = p_new_node;
		}

		p_this->p_tail = p_new_node;
		++( p_this->size );
		++( p_this->version );
	}

	return success;
}

void *single_list_pop_front( single_list_t *const p_this ) {
	void *p_popped_entry = NULL;

	if ( single_list_empty( p_this ) ) {
		// p_popped_entry = NULL;
	} else {
		p_popped_entry = p_this->p_head->p_entry;

		if ( single_list_size( p_this ) == 1 ) {
			p_this->p_node_pool = p_this->p_head; // p_next is already NULL
			p_this->p_head = NULL;
			p_this->p_tail = NULL;
			p_this->size = 0;
		} else {
			single_node_t *p_popped_node = p_this->p_head;
			p_this->p_head = p_this->p_head->p_next;
			p_popped_node->p_next = p_this->p_node_pool;
			p_this->p_node_pool = p_popped_node;
			--( p_this->size );
		}

		++( p_this->version );
	}

	return p_popped_entry;
}
void single_list_clear( single_list_t *const p_this ) {
	if ( !single_list_empty( p_this ) ) {
		p_this->p_tail->p_next = p_this->p_node_pool;
		p_this->p_node_pool = p_this->p_head;
		p_this->p_head = NULL;
		p_this->p_tail = NULL;
		p_this->size = 0;
		++( p_this->version );
	}
}
