// Author:  Douglas Wilhelm Harder
// Copyright (c) 2009 by Douglas Wilhelm Harder.  All rights reserved.

#include <iostream>
#include <string>

/***************************************************
 * Print the row vector in Matlab format.
 *
 * Run time:   O( N )
 * Memory:     O( 1 )
 ***************************************************/

template<int N>
std::ostream &operator<< ( std::ostream &out, Vector<N, ROW> const &u ) {
	out << '[';

	if ( N != 0 ) {
		out << u.array[0];

		for ( int i = 1; i < N; ++i ) {
			out << " " << u.array[i];
		}
	}

	out << ']';

	return out;
}

/***************************************************
 * Print the column vector in Matlab format using
 * a transposed row.
 *
 * Run time:   O( N )
 * Memory:     O( 1 )
 ***************************************************/

template<int N>
std::ostream &operator<< ( std::ostream &out, Vector<N, COLUMN> const &u ) {
	out << '[';

	if ( N != 0 ) {
		out << u.array[0];

		for ( int i = 1; i < N; ++i ) {
			out << " " << u.array[i];
		}
	}

	out << "]'";

	return out;
}

/***************************************************
 * Print the vector in Matlab format.
 *
 * Run time:   O( N )
 * Memory:     O( N )
 ***************************************************/

template<int N, Orientation D>
void Vector<N, D>::matlab( std::string const &s ) const {
	std::cout << s << " = [" << array[0];

	for ( int i = 1; i < N; ++i ) {
		std::cout << " " << array[i];
	}

	if ( D == ROW ) {
		std::cout << "];" << std::endl;
	} else {
		std::cout << "]';" << std::endl;
	}
}
