// Author:  Douglas Wilhelm Harder
// Copyright (c) 2009 by Douglas Wilhelm Harder.  All rights reserved.

#ifdef CA_UWATERLOO_ALUMNI_DWHARDER_SPARSE_SYSTEMS

template<int N, Orientation D>
class Vector {
	private:
		double array[N];

	public:
		// Vector Mechanics
		Vector( double x = 0.0 );
		Vector( Vector const & );

		static Vector random();

		Vector &operator= ( Vector const & );

		double &operator() ( int );
		double operator() ( int ) const;

		// Vector Functions
		double norm() const;
		double norm( int ) const;

		// Vector-Vector Functions
		Vector &operator+= ( Vector const & );
		Vector &operator-= ( Vector const & );
		Vector &operator*= ( Vector const & );
		Vector &operator/= ( Vector const & );

		// Vector-Scalar Functions
		Vector &operator+= ( double );
		Vector &operator-= ( double );
		Vector &operator*= ( double );
		Vector &operator/= ( double );

		// Vector Streaming/Printing
		void details() const;
		void matlab( std::string const & ) const;

	// Vector Functions

	template<int Nt>
	friend Vector<Nt, COLUMN> transpose( Vector<Nt, ROW> const & );

	template<int Nt>
	friend Vector<Nt, ROW> transpose( Vector<Nt, COLUMN> const & );

	// Matrix-Vector Functions

	template<int Mt, int Nt>
	friend Vector<Nt, ROW> operator* ( Vector<Mt, ROW> const &, Matrix<Mt, Nt> const & );

	template<int Mt, int Nt>
	friend Vector<Mt, COLUMN> operator* ( Matrix<Mt, Nt> const &, Vector<Nt, COLUMN> const & );

	template<int Nt>
	friend Vector<Nt, COLUMN> &operator*= ( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> & );

	template<int Nt>
	friend Vector<Nt, ROW> operator*= ( Vector<Nt, ROW> &, Matrix<Nt, Nt> const & );

	template<int Mt, int Nt>
	friend Vector<Mt, COLUMN> matrix_vector_product( Matrix<Mt, Nt> const &, Vector<Nt, COLUMN> const &, Product );

	template<int Mt, int Nt>
	friend Vector<Nt, ROW> vector_matrix_product( Vector<Mt, ROW> const &, Matrix<Mt, Nt> const &, Product );

	// Vector-Vector Functions

	template<int Nt>
	friend double operator* ( Vector<Nt, ROW> const &, Vector<Nt, COLUMN> const & );

	// Vector-Scalar Functions
	template<int Nt, Orientation Dt>
	friend Vector<Nt, Dt> operator- ( double, Vector<Nt, Dt> const & );

	template<int Nt, Orientation Dt>
	friend Vector<Nt, Dt> operator/ ( double, Vector<Nt, Dt> const & );

	// Matrix Solvers

	template<int Nt>
	friend Vector<Nt, COLUMN> diagonal_solve( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> const & );

	template<int Nt>
	friend Vector<Nt, COLUMN> backward_substitution( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> const &, bool = false );

	template<int Nt>
	friend Vector<Nt, COLUMN> forward_substitution( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> const &, bool = false );

	template<int Nt>
	friend Vector<Nt, COLUMN> jacobi( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> const &, int, double );

	template<int Nt>
	friend Vector<Nt, COLUMN> gauss_seidel( Matrix<Nt, Nt> const &, Vector<Nt, COLUMN> const &, int, double );

	// Vector Streaming

	template<int Nt>
	friend std::ostream &operator<< ( std::ostream &, Vector<Nt, ROW> const & );

	template<int Nt>
	friend std::ostream &operator<< ( std::ostream &, Vector<Nt, COLUMN> const & );

	template<int Mt, int Nt>
	friend class Matrix;
};

#include "vector_mechanics.cpp"
#include "vector_functions.cpp"
#include "vector_scalar_operations.cpp"
#include "vector_vector_operations.cpp"
#include "vector_streaming.cpp"

#endif
