/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.alumni.dwharder.Numbers;

import ca.uwaterloo.alumni.dwharder.Numbers.Complex;
import java.io.Serializable;

public class Quaternion
implements Serializable {
    final double r;
    final double i;
    final double j;
    final double k;
    static String[] units = new String[]{"i", "j", "k"};
    public static final Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    public static final Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public static final Quaternion NaN = new Quaternion(Double.NaN, Double.NaN, Double.NaN, Double.NaN);

    public Quaternion(double a, double b, double c, double d) {
        this.r = a;
        this.i = b;
        this.j = c;
        this.k = d;
    }

    public Quaternion(double a) {
        this.r = a;
        this.i = 0.0;
        this.j = 0.0;
        this.k = 0.0;
    }

    public Quaternion(double b, double c, double d) {
        this.r = 0.0;
        this.i = b;
        this.j = c;
        this.k = d;
    }

    public Quaternion(double[] v) {
        if (v.length == 3) {
            this.r = 0.0;
            this.i = v[0];
            this.j = v[1];
            this.k = v[2];
        } else if (v.length == 4) {
            this.r = v[0];
            this.i = v[1];
            this.j = v[2];
            this.k = v[3];
        } else {
            throw new IllegalArgumentException("Expecting an array of length 3 or 4, but got " + v.length);
        }
    }

    public Quaternion(double x, double[] v) {
        if (v.length != 3) {
            throw new IllegalArgumentException("Expecting an array of length 3, but got " + v.length);
        }
        this.r = x;
        this.i = v[0];
        this.j = v[1];
        this.k = v[2];
    }

    public static final Quaternion random() {
        return new Quaternion(Math.random(), Math.random(), Math.random(), Math.random());
    }

    public static final Quaternion random(int n) {
        switch (n) {
            case 0: {
                return new Quaternion(Math.random(), 0.0, 0.0, 0.0);
            }
            case 1: {
                return new Quaternion(0.0, Math.random(), 0.0, 0.0);
            }
            case 2: {
                return new Quaternion(0.0, 0.0, Math.random(), 0.0);
            }
            case 3: {
                return new Quaternion(0.0, 0.0, 0.0, Math.random());
            }
        }
        throw new IllegalArgumentException("The argument n must be 0, 1, 2, or 3 but got " + n);
    }

    public final Quaternion random(boolean[] v) {
        return new Quaternion(v[0] ? Math.random() : 0.0, v[1] ? Math.random() : 0.0, v[2] ? Math.random() : 0.0, v[3] ? Math.random() : 0.0);
    }

    public static final Quaternion randomReal() {
        return new Quaternion(Math.random(), 0.0, 0.0, 0.0);
    }

    public static final Quaternion randomImaginary() {
        return new Quaternion(0.0, Math.random(), Math.random(), Math.random());
    }

    static final double sqr(double x) {
        return x * x;
    }

    static final double sign(double x) {
        if (x > 0.0) {
            return 1.0;
        }
        if (x < 0.0) {
            return -1.0;
        }
        if (x == 0.0) {
            return Quaternion.isPositiveZero(x) ? 1.0 : -1.0;
        }
        return 1.0;
    }

    static final boolean isPositiveZero(double x) {
        return Double.doubleToLongBits(x) == 0L;
    }

    final Quaternion makeQuaternion(double real) {
        return new Quaternion(real, this.i, this.j, this.k);
    }

    final Quaternion makeQuaternionI(double real, double imag) {
        return new Quaternion(real, imag, this.j, this.k);
    }

    final Quaternion makeQuaternion(Complex z) {
        return new Quaternion(z.real(), z.imagI(), this.j, this.k);
    }

    final Quaternion makeQuaternion(double real, double imag) {
        if (Double.isNaN(imag) || Double.isInfinite(imag)) {
            return new Quaternion(real, this.i == 0.0 ? this.i : this.i * imag, this.j == 0.0 ? this.j : this.j * imag, this.k == 0.0 ? this.k : this.k * imag);
        }
        return new Quaternion(real, this.i * imag, this.j * imag, this.k * imag);
    }

    static final Quaternion branchCut(double r, double i, Quaternion u) {
        double absImagu = u.absImag();
        if (u.r != 0.0 || absImagu == 0.0 || Double.isNaN(absImagu) || Double.isInfinite(absImagu)) {
            throw new IllegalArgumentException("The argument u must be a finite non-zero imaginary imaginary");
        }
        double imag = i / absImagu;
        return new Quaternion(r, u.i * imag, u.j * imag, u.k * imag);
    }

    public final boolean equals(Object r) {
        if (r instanceof Quaternion) {
            return ((Quaternion)r).r == this.r && ((Quaternion)r).i == this.i && ((Quaternion)r).j == this.j && ((Quaternion)r).k == this.k;
        }
        return false;
    }

    public final boolean equals(Object r, double eps) {
        if (eps < 0.0) {
            throw new IllegalArgumentException("The epsilon value must be non-negative");
        }
        if (r instanceof Quaternion) {
            if (this.isZero()) {
                return ((Quaternion)r).abs() < eps;
            }
            if (((Quaternion)r).isZero()) {
                return this.abs() < eps;
            }
            return this.subtract((Quaternion)r).abs() / Math.min(((Quaternion)r).abs(), this.abs()) < eps;
        }
        return false;
    }

    public final int hashCode() {
        if (this.isZero()) {
            return 0;
        }
        if (this.isInfinite() || this.isNaN()) {
            return new Double(this.r == 0.0 ? 0.0 : this.r).hashCode() + 0x2000000B * new Double(this.i == 0.0 ? 0.0 : this.i).hashCode() + 0x40000003 * new Double(this.j == 0.0 ? 0.0 : this.j).hashCode() + 0x60000005 * new Double(this.k == 0.0 ? 0.0 : this.k).hashCode();
        }
        return new Double(this.r + this.i * 0.342562356254152 + this.j * 0.832532153125423 + this.k * 0.234577589359823).hashCode();
    }

    public final String toString() {
        return Complex.toString(this.r, new double[]{this.i, this.j, this.k}, units);
    }

    public static final String[] imaginaryUnits(String[] units) {
        if (units.length < 3) {
            throw new IllegalArgumentException("The number of entries in the array must be at least 3 but got " + units.length);
        }
        String[] oldUnits = Quaternion.units;
        Quaternion.units = (String[])units.clone();
        return oldUnits;
    }

    public final double[] toArray() {
        return new double[]{this.r, this.i, this.j, this.k};
    }

    public final double[] toArray(byte[] v) {
        double[] result = new double[v.length];
        int i = 0;
        while (i < v.length) {
            result[i] = this.coefficient(i);
            ++i;
        }
        return result;
    }

    public final double[] toImagArray() {
        return new double[]{this.i, this.j, this.k};
    }

    public final boolean isZero() {
        return this.r == 0.0 && this.i == 0.0 && this.j == 0.0 && this.k == 0.0;
    }

    public final boolean isReal() {
        return this.i == 0.0 && this.j == 0.0 && this.k == 0.0;
    }

    public final boolean isImaginary() {
        return this.r == 0.0;
    }

    public final boolean isImaginary(int n) {
        switch (n) {
            case 1: {
                return this.r == 0.0 && this.j == 0.0 && this.k == 0.0;
            }
            case 2: {
                return this.r == 0.0 && this.i == 0.0 && this.k == 0.0;
            }
            case 3: {
                return this.r == 0.0 && this.i == 0.0 && this.j == 0.0;
            }
        }
        throw new IllegalArgumentException("The argument n must be 1, 2, or 3 but got " + n);
    }

    public final boolean isImaginaryI() {
        return this.r == 0.0 && this.j == 0.0 && this.k == 0.0;
    }

    public final boolean isImaginaryJ() {
        return this.r == 0.0 && this.i == 0.0 && this.k == 0.0;
    }

    public final boolean isImaginaryK() {
        return this.r == 0.0 && this.i == 0.0 && this.j == 0.0;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.r) || Double.isNaN(this.i) || Double.isNaN(this.j) || Double.isNaN(this.k);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.r) || Double.isInfinite(this.i) || Double.isInfinite(this.j) || Double.isInfinite(this.k);
    }

    public final double abs() {
        return Math.sqrt(this.abs2());
    }

    public final double abs2() {
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k;
    }

    public final double absImag() {
        return Math.sqrt(this.abs2Imag());
    }

    public final double abs2Imag() {
        if (Double.isInfinite(this.i) || Double.isInfinite(this.j) || Double.isInfinite(this.k)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.i * this.i + this.j * this.j + this.k * this.k;
    }

    public final double real() {
        return this.r;
    }

    public final Quaternion imag() {
        return new Quaternion(0.0, this.i, this.j, this.k);
    }

    public final double imagI() {
        return this.i;
    }

    public final double imagJ() {
        return this.j;
    }

    public final double imagK() {
        return this.k;
    }

    public final double coefficient(int n) {
        switch (n) {
            case 0: {
                return this.r;
            }
            case 1: {
                return this.i;
            }
            case 2: {
                return this.j;
            }
            case 3: {
                return this.k;
            }
        }
        throw new IllegalArgumentException("The argument n must be 0, 1, 2, or 3 but got " + n);
    }

    public final Quaternion project(int n) {
        switch (n) {
            case 0: {
                return new Quaternion(this.r, 0.0, 0.0, 0.0);
            }
            case 1: {
                return new Quaternion(0.0, this.i, 0.0, 0.0);
            }
            case 2: {
                return new Quaternion(0.0, 0.0, this.j, 0.0);
            }
            case 3: {
                return new Quaternion(0.0, 0.0, 0.0, this.k);
            }
        }
        throw new IllegalArgumentException("The argument n must be 0, 1, 2, or 3 but got " + n);
    }

    public final Quaternion project(boolean[] v) {
        return new Quaternion(v[0] ? this.r : 0.0, v[1] ? this.i : 0.0, v[2] ? this.j : 0.0, v[3] ? this.k : 0.0);
    }

    public final Quaternion conjugate() {
        return new Quaternion(this.r, -this.i, -this.j, -this.k);
    }

    public final double argument() {
        return Math.atan2(this.absImag(), this.r);
    }

    public final Quaternion signum() {
        double abs = this.abs2();
        if (abs == 0.0) {
            return this;
        }
        if (Double.isInfinite(abs) || Double.isNaN(abs)) {
            if (this.isNaN()) {
                return NaN;
            }
            if (!(Double.isInfinite(this.i) || Double.isInfinite(this.j) || Double.isInfinite(this.k))) {
                return ONE;
            }
            if (!(Double.isInfinite(this.r) || Double.isInfinite(this.j) || Double.isInfinite(this.k))) {
                return I;
            }
            if (!(Double.isInfinite(this.r) || Double.isInfinite(this.i) || Double.isInfinite(this.k))) {
                return J;
            }
            if (!(Double.isInfinite(this.r) || Double.isInfinite(this.i) || Double.isInfinite(this.j))) {
                return K;
            }
            return NaN;
        }
        abs = Math.sqrt(abs);
        return new Quaternion(this.r / abs, this.i / abs, this.j / abs, this.k / abs);
    }

    public final Quaternion add(Quaternion r) {
        return new Quaternion(this.r + r.r, this.i + r.i, this.j + r.j, this.k + r.k);
    }

    public final Quaternion add(int n, double x) {
        switch (n) {
            case 0: {
                return new Quaternion(this.r + x, this.i, this.j, this.k);
            }
            case 1: {
                return new Quaternion(this.r, this.i + x, this.j, this.k);
            }
            case 2: {
                return new Quaternion(this.r, this.i, this.j + x, this.k);
            }
            case 3: {
                return new Quaternion(this.r, this.i, this.j, this.k + x);
            }
        }
        throw new IllegalArgumentException("The argument n must be 0, 1, 2, or 3 but got " + n);
    }

    public final Quaternion add(double x) {
        return new Quaternion(this.r + x, this.i, this.j, this.k);
    }

    public final Quaternion addI(double x) {
        return new Quaternion(this.r, this.i + x, this.j, this.k);
    }

    public final Quaternion addJ(double x) {
        return new Quaternion(this.r, this.i, this.j + x, this.k);
    }

    public final Quaternion addK(double x) {
        return new Quaternion(this.r, this.i, this.j, this.k + x);
    }

    public final Quaternion subtract(Quaternion r) {
        return new Quaternion(this.r - r.r, this.i - r.i, this.j - r.j, this.k - r.k);
    }

    public final Quaternion negate() {
        return new Quaternion(-this.r, -this.i, -this.j, -this.k);
    }

    public final Quaternion multiply(Quaternion r) {
        return new Quaternion(this.r * r.r - this.i * r.i - this.j * r.j - this.k * r.k, this.r * r.i + this.i * r.r + this.j * r.k - this.k * r.j, this.r * r.j - this.i * r.k + this.j * r.r + this.k * r.i, this.r * r.k + this.i * r.j - this.j * r.i + this.k * r.r);
    }

    public final Quaternion multiply(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            if (this.r == 0.0 && this.i == 0.0 && this.j == 0.0 && this.k == 0.0) {
                return NaN;
            }
            return new Quaternion(this.r == 0.0 ? this.r * Quaternion.sign(x) : this.r * x, this.i == 0.0 ? this.i * Quaternion.sign(x) : this.i * x, this.j == 0.0 ? this.j * Quaternion.sign(x) : this.j * x, this.k == 0.0 ? this.k * Quaternion.sign(x) : this.k * x);
        }
        return new Quaternion(this.r * x, this.i * x, this.j * x, this.k * x);
    }

    public final Quaternion divide(Quaternion r) {
        double abs2 = this.abs2();
        return new Quaternion((this.r * r.r + this.i * r.i + this.j * r.j + this.k * r.k) / abs2, (-this.r * r.i - this.i * r.r - this.j * r.k + this.k * r.j) / abs2, (-this.r * r.j + this.i * r.k - this.j * r.r - this.k * r.i) / abs2, (-this.r * r.k - this.i * r.j + this.j * r.i - this.k * r.r) / abs2);
    }

    public final Quaternion pow(Quaternion r) {
        return this.log().multiply(r).exp();
    }

    public final Quaternion pow(double x) {
        double absImag = this.absImag();
        Complex result = new Complex(this.r, absImag).pow(x);
        if (absImag == 0.0) {
            return this.makeQuaternion(result.r);
        }
        return this.makeQuaternion(result.r, result.i / absImag);
    }

    public final Quaternion pow(int n) {
        double absImag = this.absImag();
        Complex result = new Complex(this.r, absImag).pow(n);
        if (absImag == 0.0) {
            return this.makeQuaternion(result.r);
        }
        return this.makeQuaternion(result.r, result.i / absImag);
    }

    public final Quaternion sqr() {
        return this.makeQuaternion(this.r * this.r - this.i * this.i - this.j * this.j - this.k * this.k, 2.0 * this.r);
    }

    public final Quaternion horner(double[] v) {
        if (v.length == 0) {
            return ZERO;
        }
        if (v.length == 1) {
            return new Quaternion(v[0]);
        }
        double absImag = this.absImag();
        Complex result = new Complex(this.r, absImag).horner(v);
        if (absImag == 0.0) {
            return this.makeQuaternion(result.r);
        }
        return this.makeQuaternion(result.r, result.i / absImag);
    }

    public final Quaternion sqrt() {
        double abs = this.abs();
        double absImag = this.absImag();
        if (abs == 0.0) {
            return this;
        }
        if (absImag == 0.0) {
            if (this.r > 0.0) {
                return new Quaternion(Math.sqrt(this.r), 0.0, 0.0, 0.0);
            }
            return new Quaternion(0.0, Math.sqrt(-this.r), 0.0, 0.0);
        }
        double imag = Math.sqrt(0.5 * (abs - this.r)) / absImag;
        return new Quaternion(Math.sqrt(0.5 * (abs + this.r)), this.i * imag, this.j * imag, this.k * imag);
    }

    public final Quaternion sqrt(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r >= 0.0) {
            return this.sqrt();
        }
        Complex z = new Complex(this.r, absImag).sqrt();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion rotateAround(Quaternion r) {
        if (this.r != 0.0) {
            throw new IllegalArgumentException("Cannot rotate a non-imaginary quaternion.");
        }
        double absr2 = r.abs2Imag();
        if (absr2 == 0.0) {
            throw new IllegalArgumentException("Cannot rotate around a quaternion with a zero imaginary part.");
        }
        absr2 += Quaternion.sqr(r.r);
        double rr2 = r.r * r.r;
        double ri2 = r.i * r.i;
        double rj2 = r.j * r.j;
        double rk2 = r.k * r.k;
        double rri = r.r * r.i;
        double rrj = r.r * r.j;
        double rrk = r.r * r.k;
        double rij = r.i * r.j;
        double rik = r.i * r.k;
        double rjk = r.j * r.k;
        return new Quaternion(0.0, (2.0 * (this.j * (rij - rrk) + this.k * (rik + rrj)) + this.i * (rr2 + ri2 - rj2 - rk2)) / absr2, (2.0 * (this.i * (rij + rrk) + this.k * (rjk - rri)) + this.j * (rr2 - ri2 + rj2 - rk2)) / absr2, (2.0 * (this.i * (rik - rrj) + this.j * (rjk + rri)) + this.k * (rr2 - ri2 - rj2 + rk2)) / absr2);
    }

    public final Quaternion exp() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.exp(this.r));
        }
        double expr = Math.exp(this.r);
        return this.makeQuaternion(expr * Math.cos(absImag), expr * (Math.sin(absImag) / absImag));
    }

    public final Quaternion log() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            if (this.r >= 0.0) {
                return this.makeQuaternion(Math.log(this.r));
            }
            return this.makeQuaternionI(Math.log(-this.r), Math.PI);
        }
        return this.makeQuaternion(Math.log(this.abs()), Math.atan2(absImag, this.r) / absImag);
    }

    public final Quaternion log(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r > 0.0) {
            return this.log();
        }
        Complex z = new Complex(this.r, absImag).log();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion log10() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            if (this.r >= 0.0) {
                return this.makeQuaternion(Math.log10(this.r));
            }
            return this.makeQuaternionI(Math.log10(-this.r), Math.PI);
        }
        return this.makeQuaternion(Math.log10(this.abs()), Math.atan2(absImag, this.r) / absImag / Math.log(10.0));
    }

    public final Quaternion log10(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r > 0.0) {
            return this.log10();
        }
        Complex z = new Complex(this.r, absImag).log10();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion sin() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.sin(this.r));
        }
        return this.makeQuaternion(Math.sin(this.r) * Math.cosh(absImag), Math.cos(this.r) * Math.sinh(absImag) / absImag);
    }

    public final Quaternion cos() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.cos(this.r));
        }
        return this.makeQuaternion(Math.cos(this.r) * Math.cosh(absImag), -Math.sin(this.r) * (Math.sinh(absImag) / absImag));
    }

    public final Quaternion tan() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.tan(this.r));
        }
        double denom = Quaternion.sqr(Math.cos(this.r)) + Quaternion.sqr(Math.sinh(absImag));
        return this.makeQuaternion(Math.cos(this.r) * Math.sin(this.r) / denom, Math.cosh(absImag) * (Math.sinh(absImag) / absImag) / denom);
    }

    public final Quaternion sec() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.cos(this.r));
        }
        double denom = Quaternion.sqr(Math.cos(this.r)) + Quaternion.sqr(Math.sinh(absImag));
        return this.makeQuaternion(Math.cos(this.r) * Math.cosh(absImag) / denom, Math.sin(this.r) * (Math.sinh(absImag) / absImag) / denom);
    }

    public final Quaternion csc() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.sin(this.r));
        }
        double denom = Quaternion.sqr(Math.sin(this.r)) + Quaternion.sqr(Math.sinh(absImag));
        return this.makeQuaternion(Math.sin(this.r) * Math.cosh(absImag) / denom, -Math.cos(this.r) * (Math.sinh(absImag) / absImag) / denom);
    }

    public final Quaternion cot() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.tan(this.r));
        }
        double denom = Quaternion.sqr(Math.sin(this.r)) + Quaternion.sqr(Math.sinh(absImag));
        return this.makeQuaternion(Math.sin(this.r) * Math.cos(this.r) / denom, -Math.cosh(absImag) * (Math.sinh(absImag) / absImag) / denom);
    }

    public final Quaternion sinh() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.sinh(this.r));
        }
        return this.makeQuaternion(Math.sinh(this.r) * Math.cos(absImag), Math.cosh(this.r) * (Math.sin(absImag) / absImag));
    }

    public final Quaternion cosh() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.cosh(this.r));
        }
        return this.makeQuaternion(Math.cosh(this.r) * Math.cos(absImag), Math.sinh(this.r) * Math.sin(absImag) / absImag);
    }

    public final Quaternion tanh() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(Math.tanh(this.r));
        }
        double denom = Quaternion.sqr(Math.sinh(this.r)) + Quaternion.sqr(Math.cos(absImag));
        return this.makeQuaternion(Math.cosh(this.r) * Math.sinh(this.r) / denom, Math.cos(absImag) * (Math.sin(absImag) / absImag) / denom);
    }

    public final Quaternion sech() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.cosh(this.r));
        }
        double denom = Quaternion.sqr(Math.sinh(this.r)) + Quaternion.sqr(Math.cos(absImag));
        return this.makeQuaternion(Math.cosh(this.r) * Math.cos(absImag) / denom, -Math.sinh(this.r) * (Math.sin(absImag) / absImag) / denom);
    }

    public final Quaternion csch() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.sinh(this.r));
        }
        double denom = Quaternion.sqr(Math.sinh(this.r)) + Quaternion.sqr(Math.sin(absImag));
        return this.makeQuaternion(Math.sinh(this.r) * Math.cos(absImag) / denom, -Math.cosh(this.r) * (Math.sin(absImag) / absImag) / denom);
    }

    public final Quaternion coth() {
        double absImag = this.absImag();
        if (absImag == 0.0) {
            return this.makeQuaternion(1.0 / Math.tanh(this.r));
        }
        double denom = Quaternion.sqr(Math.sinh(this.r)) + Quaternion.sqr(Math.sin(absImag));
        return this.makeQuaternion(Math.sinh(this.r) * Math.cosh(this.r) / denom, Math.cos(absImag) * (Math.sin(absImag) / absImag) / denom);
    }

    public final Quaternion asin() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).asin();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion asin(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r >= -1.0 && this.r <= 1.0) {
            return this.asin();
        }
        Complex z = new Complex(this.r, absImag).asin();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acos() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acos();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acos(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r >= -1.0 && this.r <= 1.0) {
            return this.acos();
        }
        Complex z = new Complex(this.r, absImag).acos();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion atan() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).atan();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion atan(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag < 1.0) {
            return this.atan();
        }
        Complex z = new Complex(this.r, absImag).atan();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion asec() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).asec();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion asec(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag >= 1.0) {
            return this.asec();
        }
        Complex z = new Complex(this.r, absImag).asec();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acsc() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acsc();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acsc(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag >= 1.0) {
            return this.acsc();
        }
        Complex z = new Complex(this.r, absImag).acsc();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acot() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acot();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acot(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag >= 1.0) {
            return this.acot();
        }
        Complex z = new Complex(this.r, absImag).acot();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion asinh() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).asinh();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion asinh(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag <= 1.0) {
            return this.asinh();
        }
        Complex z = new Complex(this.r, absImag).asinh();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acosh() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acosh();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acosh(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r >= 1.0) {
            return this.acosh();
        }
        Complex z = new Complex(this.r, absImag).acosh();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion atanh() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).atanh();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion atanh(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r > -1.0 && this.r < 1.0) {
            return this.atanh();
        }
        Complex z = new Complex(this.r, absImag).atanh();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion asech() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).asech();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion asech(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r > 0.0 && this.r <= 1.0) {
            return this.asech();
        }
        Complex z = new Complex(this.r, absImag).asech();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acsch() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acsch();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acsch(Quaternion u) {
        double absImag = this.absImag();
        if (this.r != 0.0 || absImag >= 1.0) {
            return this.acsch();
        }
        Complex z = new Complex(this.r, absImag).acsch();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion acoth() {
        double absImag = this.absImag();
        Complex z = new Complex(this.r, absImag).acoth();
        if (absImag == 0.0) {
            return this.makeQuaternion(z);
        }
        return this.makeQuaternion(z.real(), z.imagI() / absImag);
    }

    public final Quaternion acoth(Quaternion u) {
        double absImag = this.absImag();
        if (absImag != 0.0 || this.r < -1.0 || this.r > 1.0) {
            return this.acoth();
        }
        Complex z = new Complex(this.r, absImag).acoth();
        return Quaternion.branchCut(z.real(), z.imagI(), u);
    }

    public final Quaternion ceil() {
        return new Quaternion(Math.ceil(this.r), Math.ceil(this.i), Math.ceil(this.j), Math.ceil(this.k));
    }

    public final Quaternion floor() {
        return new Quaternion(Math.floor(this.r), Math.floor(this.i), Math.floor(this.j), Math.floor(this.k));
    }

    public final Quaternion rint() {
        return new Quaternion(Math.rint(this.r), Math.rint(this.i), Math.rint(this.j), Math.rint(this.k));
    }
}

