/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.alumni.dwharder.Numbers;

import ca.uwaterloo.alumni.dwharder.Numbers.Sedenion;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

final class Fractal {
    int count = 0;
    Element[] table;
    int mod = 131071;
    Color ambient = Color.BLACK;
    Lamp lamps;

    Fractal() {
        this.table = new Element[131072];
    }

    void add(int x, int y, int z) {
        if (this.count == this.table.length) {
            Element[] tmp = new Element[2 * this.table.length];
            this.mod = 2 * this.table.length - 1;
            int i = 0;
            while (i < this.table.length) {
                Element ref = this.table[i];
                while (ref != null) {
                    Element refNext = ref.next;
                    int h = ref.hash & this.mod;
                    ref.next = tmp[h];
                    tmp[h] = ref;
                    ref = refNext;
                }
                ++i;
            }
            this.table = tmp;
        }
        int h = x + 10007 * y + 100000007 * z & this.mod;
        this.table[h] = new Element(x, y, z, this.table[h]);
        ++this.count;
    }

    public boolean contains(int x, int y, int z) {
        Element ref = this.table[x + 10007 * y + 100000007 * z & this.mod];
        while (ref != null) {
            if (x == ref.x && y == ref.y && z == ref.z) {
                return true;
            }
            ref = ref.next;
        }
        return false;
    }

    public void addAmbientLight(Color c) {
        this.ambient = c;
    }

    void add(int x, int y, int z, Color c) {
        this.lamps = new Lamp(x, y, z, c, this.lamps);
    }

    private static ColorModel generateColorModel() {
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        r[1] = 0;
        g[1] = 0;
        b[1] = -64;
        r[2] = 0;
        g[2] = 0;
        b[2] = -1;
        r[3] = 0;
        g[3] = -64;
        b[3] = 0;
        r[4] = 0;
        g[4] = -1;
        b[4] = 0;
        r[5] = 0;
        g[5] = -64;
        b[5] = -64;
        r[6] = 0;
        g[6] = -1;
        b[6] = -1;
        r[7] = -64;
        g[7] = 0;
        b[7] = 0;
        r[8] = -1;
        g[8] = 0;
        b[8] = 0;
        r[9] = -64;
        g[9] = 0;
        b[9] = -64;
        r[10] = -1;
        g[10] = 0;
        b[10] = -1;
        r[11] = -64;
        g[11] = -64;
        b[11] = 0;
        r[12] = -1;
        g[12] = -1;
        b[12] = 0;
        r[13] = 80;
        g[13] = 80;
        b[13] = 80;
        r[14] = -64;
        g[14] = -64;
        b[14] = -64;
        r[15] = -1;
        g[15] = -1;
        b[15] = -1;
        return new IndexColorModel(4, 16, r, g, b);
    }

    public static void render2D(int width, byte maxIterations) {
        boolean[][][] layers = new boolean[3][width + 1][width + 1];
        Sedenion c = Sedenion.random();
        c = c.multiply(0.25 / c.abs());
        Sedenion c2 = Sedenion.randomImaginary();
        c2 = c2.multiply(0.25 / c2.abs()).add(-1.0);
        Fractal points = new Fractal();
        int i = 0;
        while (i <= width) {
            double z;
            double y;
            double x = -2.0 + 4.0 * (double)i / (double)width;
            int j = 0;
            while (j <= width) {
                y = -2.0 + 4.0 * (double)j / (double)width;
                int k = 0;
                while (k <= width) {
                    z = -2.0 + 4.0 * (double)k / (double)width;
                    Sedenion o = new Sedenion(-0.5, x, y, 0.1, z, 0.0, 0.1, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0);
                    layers[i % 3][j][k] = Fractal.iterate(o, c, c2, maxIterations) == maxIterations;
                    ++k;
                }
                ++j;
            }
            x = -2.0 + 4.0 * (double)(i - 1) / (double)width;
            if (i >= 2) {
                int idx = (i - 1) % 3;
                int j2 = 1;
                while (j2 < width) {
                    y = -2.0 + 4.0 * (double)j2 / (double)width;
                    int k = 1;
                    while (k < width) {
                        z = -2.0 + 4.0 * (double)k / (double)width;
                        if (layers[idx][j2][k]) {
                            int sum = 0;
                            int ii = 0;
                            while (ii <= 2) {
                                int jj = j2 - 1;
                                while (jj <= j2 + 1) {
                                    int kk = k - 1;
                                    while (kk <= k + 1) {
                                        if (layers[ii][jj][kk]) {
                                            ++sum;
                                        }
                                        ++kk;
                                    }
                                    ++jj;
                                }
                                ++ii;
                            }
                            if (sum <= 26) {
                                points.add(i, j2, k);
                            }
                        }
                        ++k;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        System.out.println("NULL];");
    }

    public static final int iterate(Sedenion o, Sedenion c, Sedenion c2, int maxIterations) {
        Sedenion t = o;
        int n = 0;
        while (n < maxIterations) {
            if ((t = t.sqr().multiply(c).subtract(t.multiply(t.multiply(c)).multiply(2.0)).add(c2)).abs2() >= 4.0) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public void render(String fileName, int width, int height) {
        ColorModel colorModel = Fractal.generateColorModel();
        byte[] pixels = new byte[height * width];
        Sedenion c = Sedenion.randomImaginary();
        c = c.multiply(0.2 / c.abs()).add(-1.0);
        Sedenion c2 = Sedenion.randomImaginary();
        c2 = c2.multiply(0.1 / c2.abs()).add(-1.0);
        int pixelCount = 0;
        int i = 0;
        while (i < height) {
            double x = -1.0 + 2.0 * (double)i / (double)(height - 1);
            int j = 0;
            while (j < width) {
                double y = -1.0 + 2.0 * (double)j / (double)(width - 1);
                Sedenion o = new Sedenion(-0.4, x, y, 0.1, 0.0, 0.0, 0.1, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0);
                pixels[pixelCount] = (byte)(Fractal.iterate(o, c, c2, 100) % 16);
                ++pixelCount;
                ++j;
            }
            ++i;
        }
        DataBufferByte dbuf = new DataBufferByte(pixels, width * height, 0);
        int numBanks = dbuf.getNumBanks();
        int[] bitMasks = new int[]{15};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, width, height, bitMasks);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        File outputFile = new File(fileName);
        try {
            ImageIO.write((RenderedImage)image, "PNG", outputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Fractal f = new Fractal();
        f.render("fractal3.png", 1024, 1024);
    }

    final class Element {
        final int x;
        final int y;
        final int z;
        final int hash;
        Element next;

        Element(int x, int y, int z, Element next) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.hash = x + 10007 * y + 100000007 * z & Integer.MAX_VALUE;
            this.next = next;
        }
    }

    final class Lamp {
        final int x;
        final int y;
        final int z;
        final Color color;
        final Lamp next;

        Lamp(int x, int y, int z, Color c, Lamp next) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.color = c;
            this.next = next;
        }
    }
}

