/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.alumni.dwharder.Numbers;

import java.io.Serializable;

public final class Complex
implements Serializable {
    final double r;
    final double i;
    static String[] units = new String[]{"i"};
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    static final double LOG10 = Math.log(10.0);
    static final double PI2 = 1.5707963267948966;

    public Complex(double a, double b) {
        this.r = a;
        this.i = b;
    }

    public Complex(double b) {
        this.r = 0.0;
        this.i = b;
    }

    public Complex(double[] v) {
        if (v.length == 1) {
            this.r = 0.0;
            this.i = v[0];
        } else if (v.length == 2) {
            this.r = v[0];
            this.i = v[1];
        } else {
            throw new IllegalArgumentException("Expecting an array of length 1 or 2, but got " + v.length);
        }
    }

    public static final Complex random() {
        return new Complex(Math.random(), Math.random());
    }

    public static final Complex random(int n) {
        switch (n) {
            case 0: {
                return new Complex(Math.random(), 0.0);
            }
            case 1: {
                return new Complex(0.0, Math.random());
            }
        }
        throw new IllegalArgumentException("The argument n must be 0 or 1 but got " + n);
    }

    public final Complex random(boolean[] v) {
        return new Complex(v[0] ? Math.random() : 0.0, v[1] ? Math.random() : 0.0);
    }

    public static final Complex randomReal() {
        return new Complex(Math.random(), 0.0);
    }

    public static final Complex randomImaginary() {
        return new Complex(0.0, Math.random());
    }

    static final double sqr(double r) {
        return r * r;
    }

    static final double sign(double r) {
        if (r > 0.0) {
            return 1.0;
        }
        if (r < 0.0) {
            return -1.0;
        }
        if (r == 0.0) {
            return Complex.isPositiveZero(r) ? 1.0 : -1.0;
        }
        return 1.0;
    }

    static final boolean isPositiveZero(double r) {
        return Double.doubleToLongBits(r) == 0L;
    }

    public final boolean equals(Object w) {
        if (w instanceof Complex) {
            return ((Complex)w).r == this.r && ((Complex)w).i == this.i;
        }
        return false;
    }

    public final boolean equals(Object z, double eps) {
        if (eps < 0.0) {
            throw new IllegalArgumentException("The epsilon value must be non-negative");
        }
        if (z instanceof Complex) {
            if (this.isZero()) {
                return ((Complex)z).abs() < eps;
            }
            if (((Complex)z).isZero()) {
                return this.abs() < eps;
            }
            return this.subtract((Complex)z).abs() / Math.min(((Complex)z).abs(), this.abs()) < eps;
        }
        return false;
    }

    public final int hashCode() {
        return new Double(this.r == 0.0 ? 0.0 : this.r).hashCode() + 0x2000000B * new Double(this.i == 0.0 ? 0.0 : this.i).hashCode();
    }

    static final String toString(double r, double[] array, String[] units) {
        StringBuffer result = new StringBuffer();
        result.append(r);
        int i = 0;
        while (i < array.length) {
            if (Complex.sign(array[i]) == -1.0) {
                if (array[i] != 0.0) {
                    result.append(" - ");
                    result.append(units[i]);
                    if (array[i] != -1.0) {
                        result.append(-array[i]);
                    }
                }
            } else if (array[i] != 0.0) {
                result.append(" + ");
                result.append(units[i]);
                if (array[i] != 1.0) {
                    result.append(array[i]);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public final String toString() {
        return Complex.toString(this.r, new double[]{this.i}, units);
    }

    public static final String imaginaryUnit(String s) {
        String oldUnit = units[0];
        units = new String[]{s};
        return oldUnit;
    }

    static final String toMathMLContentString(double x) {
        if (Double.isNaN(x)) {
            return "<notanumber/>";
        }
        if (Double.isInfinite(x)) {
            if (x < 0.0) {
                return "<apply><minus/><infinity/></apply>";
            }
            return "<infinity/>";
        }
        return "<cn>" + x + "</cn>";
    }

    public final String toMathMLContent() {
        if (this.isNaN() || this.isInfinite()) {
            String real = Complex.toMathMLContentString(this.r);
            String sign = Complex.sign(this.i) == 1.0 ? "<plus/>" : "<minus/>";
            String imag = Complex.toMathMLContentString(Math.abs(this.i));
            return "<apply>" + sign + real + "<apply><times/><imaginaryi/>" + imag + "</apply></apply>";
        }
        return "<cn type=\"complex-cartesian\">" + this.r + "<sep/>" + this.i + "</cn>";
    }

    public final String toMathMLPresentation() {
        String real = Double.isInfinite(this.r) ? (this.r > 0.0 ? "<mi>&infin;</mi>" : "<mrow><mo>-</mo><mi>&infin;</mi></mrow>") : (Double.isNaN(this.r) ? "<mi>&NaN;</mi>" : "<mn>" + this.r + "</mn>");
        String imag = Double.isInfinite(this.i) ? "<mi>&infin;</mi>" : (Double.isNaN(this.i) ? "<mi>&NaN;</mi>" : "<mn>" + Math.abs(this.i) + "</mn>");
        String sign = Complex.sign(this.i) == 1.0 ? "<mo>+</mo>" : "<mo>-</mo>";
        return "<mrow>" + real + sign + "<mrow><mo><mi>&ImaginaryI;</mi>&InvisibleTimes;</mo>" + imag + "</mrow></mrow>";
    }

    public final double[] toArray() {
        return new double[]{this.r, this.i};
    }

    public final double[] toArray(byte[] v) {
        double[] result = new double[v.length];
        int i = 0;
        while (i < v.length) {
            result[i] = this.coefficient(i);
            ++i;
        }
        return result;
    }

    public final boolean isZero() {
        return this.r == 0.0 && this.i == 0.0;
    }

    public final boolean isReal() {
        return this.i == 0.0;
    }

    public final boolean isImaginary() {
        return this.r == 0.0;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.r) || Double.isNaN(this.i);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.r) || Double.isInfinite(this.i);
    }

    public final double abs() {
        return Math.sqrt(this.abs2());
    }

    public final double abs2() {
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.r * this.r + this.i * this.i;
    }

    public final double real() {
        return this.r;
    }

    public final Complex imag() {
        return new Complex(0.0, this.i);
    }

    public final double imagI() {
        return this.i;
    }

    public final double coefficient(int n) {
        switch (n) {
            case 0: {
                return this.r;
            }
            case 1: {
                return this.i;
            }
        }
        throw new IllegalArgumentException("The argument n must be 0 or 1 but got " + n);
    }

    public final Complex project(int n) {
        switch (n) {
            case 0: {
                return new Complex(this.r, 0.0);
            }
            case 1: {
                return new Complex(0.0, this.i);
            }
        }
        throw new IllegalArgumentException("The argument n must be 0 or 1 but got " + n);
    }

    public final Complex project(boolean[] v) {
        return new Complex(v[0] ? this.r : 0.0, v[1] ? this.i : 0.0);
    }

    public final Complex conjugate() {
        return new Complex(this.r, -this.i);
    }

    public final double argument() {
        return Math.atan2(this.i, this.r);
    }

    public final Complex signum() {
        double abs = this.abs();
        if (abs == 0.0) {
            return this;
        }
        if (Double.isInfinite(abs) || Double.isNaN(abs)) {
            if (Double.isInfinite(this.r) && Double.isInfinite(this.i)) {
                return new Complex(Double.NaN, Double.NaN);
            }
            if (this.isNaN()) {
                return new Complex(Double.NaN, Double.NaN);
            }
            if (Double.isInfinite(this.r)) {
                return ONE;
            }
            return I;
        }
        abs = Math.sqrt(abs);
        return new Complex(this.r / abs, this.i / abs);
    }

    public final double csgn() {
        if (this.r > 0.0) {
            return 1.0;
        }
        if (this.r < 0.0) {
            return -1.0;
        }
        if (this.i == 0.0) {
            return 0.0;
        }
        return Complex.isPositiveZero(this.r) || Double.isNaN(this.r) ? 1.0 : -1.0;
    }

    public final Complex add(Complex w) {
        return new Complex(this.r + w.r, this.i + w.i);
    }

    public final Complex add(int n, double x) {
        switch (n) {
            case 0: {
                return new Complex(this.r + x, this.i);
            }
            case 1: {
                return new Complex(this.r, this.i + x);
            }
        }
        throw new IllegalArgumentException("The argument n must be 0 or 1 but got " + n);
    }

    public final Complex add(double x) {
        return new Complex(this.r + x, this.i);
    }

    public final Complex addI(double x) {
        return new Complex(this.r, this.i + x);
    }

    public final Complex subtract(Complex w) {
        return new Complex(this.r - w.r, this.i - w.i);
    }

    public final Complex negate() {
        return new Complex(-this.r, -this.i);
    }

    public final Complex multiply(Complex w) {
        if (this.isNaN() || w.isNaN() || this.isInfinite() || w.isInfinite()) {
            if (this.r == 0.0 && this.i == 0.0 || w.r == 0.0 && w.i == 0.0) {
                return new Complex(this.r * w.r - this.i * w.i, this.r * w.i + this.i * w.r);
            }
            if (this.r == 0.0 && w.r == 0.0) {
                return new Complex(-this.i * w.i, 0.0);
            }
            if (this.r == 0.0 && w.i == 0.0) {
                return new Complex(0.0, this.i * w.r);
            }
            if (this.i == 0.0 && w.r == 0.0) {
                return new Complex(0.0, this.r * w.i);
            }
            if (this.i == 0.0 && w.i == 0.0) {
                return new Complex(this.r * w.r, 0.0);
            }
            if (this.r == 0.0) {
                return new Complex(-this.i * w.i, this.i * w.r);
            }
            if (this.i == 0.0) {
                return new Complex(this.r * w.r, this.r * w.i);
            }
            if (w.r == 0.0) {
                return new Complex(-this.i * w.i, this.r * w.i);
            }
            if (w.i == 0.0) {
                return new Complex(this.r * w.r, this.i * w.r);
            }
            if (Double.isNaN(this.r) && Double.isNaN(this.i) || Double.isNaN(w.r) && Double.isNaN(w.i)) {
                return new Complex(Double.NaN, Double.NaN);
            }
            if (this.isInfinite() || w.isInfinite()) {
                return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
        }
        return new Complex(this.r * w.r - this.i * w.i, this.r * w.i + this.i * w.r);
    }

    public final Complex multiply(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            if (this.r == 0.0 && this.i != 0.0) {
                return new Complex(this.r * Complex.sign(x), this.i * x);
            }
            if (this.r != 0.0 && this.i == 0.0) {
                return new Complex(this.r * x, this.i * Complex.sign(x));
            }
        }
        return new Complex(this.r * x, this.i * x);
    }

    public final Complex multiplyI(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            if (this.r == 0.0 && this.i != 0.0) {
                return new Complex(-this.i * x, this.r * Complex.sign(x));
            }
            if (this.r != 0.0 && this.i == 0.0) {
                return new Complex(-this.i * Complex.sign(x), this.r * x);
            }
        }
        return new Complex(-this.i * x, this.r * x);
    }

    public final Complex divide(Complex w) {
        double abs2 = w.r * w.r + w.i * w.i;
        return new Complex((this.r * w.r + this.i * w.i) / abs2, (-this.r * w.i + this.i * w.r) / abs2);
    }

    public final Complex pow(Complex w) {
        double a = 0.5 * Math.log(this.abs2());
        double b = Math.atan2(this.i, this.r);
        double c = Math.exp(w.r * a - w.i * b);
        double d = w.i * a + w.r * b;
        return new Complex(c * Math.cos(d), c * Math.sin(d));
    }

    public final Complex pow(double x) {
        if (x == 0.0) {
            return ONE;
        }
        if (this.r == 0.0 && this.i == 0.0) {
            return this;
        }
        if (this.i == 0.0) {
            return new Complex(Math.pow(this.r, x), this.i);
        }
        double expr = Math.pow(this.abs2(), 0.5 * x);
        double arg = x * Math.atan2(this.i, this.r);
        return new Complex(expr * Math.cos(arg), expr * Math.sin(arg));
    }

    public final Complex pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (this.r == 0.0 && this.i == 0.0) {
            return this;
        }
        if (this.i == 0.0) {
            return new Complex(Math.pow(this.r, n), this.i);
        }
        if (this.r == 0.0) {
            int result = n % 4;
            if (result < 0) {
                result += 4;
            }
            switch (result) {
                case 0: {
                    return new Complex(Math.pow(this.i, n), 0.0);
                }
                case 1: {
                    return new Complex(0.0, Math.pow(this.i, n));
                }
                case 2: {
                    return new Complex(-Math.pow(this.i, n), 0.0);
                }
                case 3: {
                    return new Complex(0.0, -Math.pow(this.i, n));
                }
            }
            return null;
        }
        double expr = n % 2 == 0 ? Math.pow(this.abs2(), n / 2) : Math.pow(this.abs(), n);
        double arg = (double)n * Math.atan2(this.i, this.r);
        return new Complex(expr * Math.cos(arg), expr * Math.sin(arg));
    }

    public final Complex sqr() {
        return new Complex(this.r * this.r - this.i * this.i, 2.0 * this.r * this.i);
    }

    public final Complex horner(double[] v) {
        if (v.length == 0) {
            return ZERO;
        }
        if (v.length == 1) {
            return new Complex(v[0], 0.0);
        }
        if (this.isNaN() || this.isInfinite()) {
            Complex result = this.multiply(v[v.length - 1]);
            int i = v.length - 2;
            while (i > 0) {
                result = this.multiply(result.add(v[i]));
                --i;
            }
            return result.add(v[0]);
        }
        double a = this.r * v[v.length - 1];
        double b = this.i * v[v.length - 1];
        int j = v.length - 2;
        while (j > 0) {
            double at = a + v[j];
            a = this.r * at - this.i * b;
            b = this.r * b + this.i * at;
            --j;
        }
        return new Complex(a + v[0], b);
    }

    public final Complex horner(Complex[] v) {
        if (v.length == 0) {
            return ZERO;
        }
        if (v.length == 1) {
            return v[0];
        }
        Complex result = this.multiply(v[v.length - 1]);
        int i = v.length - 2;
        while (i > 0) {
            result = this.multiply(result.add(v[i]));
            --i;
        }
        return result.add(v[0]);
    }

    public final Complex sqrt() {
        double val = Math.sqrt(this.r * this.r + this.i * this.i);
        return new Complex(0.5 * Math.sqrt(2.0 * val + 2.0 * this.r), 0.5 * new Complex(this.i, -this.r).csgn() * Math.sqrt(2.0 * val - 2.0 * this.r));
    }

    public final Complex exp() {
        double expr = Math.exp(this.r);
        return new Complex(expr * Math.cos(this.i), expr * Math.sin(this.i));
    }

    public final Complex log() {
        if (this.i == 0.0) {
            if (this.r < 0.0) {
                return new Complex(0.5 * Math.log(this.abs2()), Math.PI * Complex.sign(this.i));
            }
            if (this.r == 0.0) {
                return new Complex(Double.NEGATIVE_INFINITY, Double.NaN);
            }
            return new Complex(0.5 * Math.log(this.abs2()), 0.0 * Complex.sign(this.i));
        }
        return new Complex(0.5 * Math.log(this.abs2()), Math.atan2(this.i, this.r));
    }

    public final Complex log10() {
        return new Complex(0.5 * Math.log(this.abs2()) / LOG10, Math.atan2(this.i, this.r) / LOG10);
    }

    public final Complex sin() {
        if (this.i == 0.0) {
            return new Complex(Math.sin(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, Math.sinh(this.i));
        }
        return new Complex(Math.sin(this.r) * Math.cosh(this.i), Math.cos(this.r) * Math.sinh(this.i));
    }

    public final Complex cos() {
        if (this.i == 0.0) {
            return new Complex(Math.cos(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(Math.cosh(this.i), this.r);
        }
        return new Complex(Math.cos(this.r) * Math.cosh(this.i), -Math.sin(this.r) * Math.sinh(this.i));
    }

    public final Complex tan() {
        if (this.i == 0.0) {
            return new Complex(Math.tan(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, Math.tanh(this.i));
        }
        double denom = Complex.sqr(Math.cos(this.r)) + Complex.sqr(Math.sinh(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        return new Complex(Math.sin(this.r) * (Math.cos(this.r) / denom), Math.sinh(this.i) / denom * Math.cosh(this.i));
    }

    public final Complex sec() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.cos(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(1.0 / Math.cosh(this.i), this.r);
        }
        double denom = Complex.sqr(Math.cos(this.r)) + Complex.sqr(Math.sinh(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        return new Complex(Math.cosh(this.i) * (Math.cos(this.r) / denom), Math.sinh(this.i) / denom * Math.sin(this.r));
    }

    public final Complex csc() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.sin(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, -1.0 / Math.sinh(this.i));
        }
        double denom = Complex.sqr(Math.sin(this.r)) + Complex.sqr(Math.sinh(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        return new Complex(Math.cosh(this.i) * (Math.sin(this.r) / denom), -(Math.sinh(this.i) / denom) * Math.cos(this.r));
    }

    public final Complex cot() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.tan(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, -1.0 / Math.tanh(this.i));
        }
        double denom = Complex.sqr(Math.sin(this.r)) + Complex.sqr(Math.sinh(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        return new Complex(Math.cos(this.r) * (Math.sin(this.r) / denom), -(Math.sinh(this.i) / denom) * Math.cosh(this.i));
    }

    public final Complex sinh() {
        if (this.i == 0.0) {
            return new Complex(Math.sinh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, Math.sin(this.i));
        }
        return new Complex(Math.sinh(this.r) * Math.cos(this.i), Math.cosh(this.r) * Math.sin(this.i));
    }

    public final Complex cosh() {
        if (this.i == 0.0) {
            return new Complex(Math.cosh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(Math.cos(this.i), this.r);
        }
        return new Complex(Math.cosh(this.r) * Math.cos(this.i), Math.sinh(this.r) * Math.sin(this.i));
    }

    public final Complex tanh() {
        if (this.i == 0.0) {
            return new Complex(Math.tanh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, Math.tan(this.i));
        }
        double denom = Complex.sqr(Math.sinh(this.r)) + Complex.sqr(Math.cos(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        return new Complex(Math.cosh(this.r) * (Math.sinh(this.r) / denom), Math.sin(this.i) * (Math.cos(this.i) / denom));
    }

    public final Complex sech() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.cosh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(1.0 / Math.cos(this.i), this.r);
        }
        double denom = Complex.sqr(Math.sinh(this.r)) + Complex.sqr(Math.cos(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        return new Complex(Math.cosh(this.r) * (Math.cos(this.i) / denom), -Math.sin(this.i) * (Math.sinh(this.r) / denom));
    }

    public final Complex csch() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.sinh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, -1.0 / Math.sin(this.i));
        }
        double denom = Complex.sqr(Math.sinh(this.r)) + Complex.sqr(Math.sin(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        return new Complex(Math.cos(this.i) * (Math.sinh(this.r) / denom), -Math.cosh(this.r) * (Math.sin(this.i) / denom));
    }

    public final Complex coth() {
        if (this.i == 0.0) {
            return new Complex(1.0 / Math.tanh(this.r), this.i);
        }
        if (this.r == 0.0) {
            return new Complex(this.r, -1.0 / Math.tan(this.i));
        }
        double denom = Complex.sqr(Math.sinh(this.r)) + Complex.sqr(Math.sin(this.i));
        if (denom == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        return new Complex(Math.cosh(this.r) * (Math.sinh(this.r) / denom), -Math.cos(this.i) * (Math.sin(this.i) / denom));
    }

    public final Complex asin() {
        if (this.i == 0.0) {
            if (this.r < -1.0 || this.r > 1.0) {
                double v1 = 0.5 * Math.sqrt(this.r * this.r + 2.0 * this.r + 1.0);
                double v2 = 0.5 * Math.sqrt(this.r * this.r - 2.0 * this.r + 1.0);
                return new Complex(1.5707963267948966, new Complex(this.i, -this.r).csgn() * Math.log(v1 + v2 + Math.sqrt(Complex.sqr(v1 + v2) - 1.0)));
            }
            return new Complex(Math.asin(this.r), 0.0);
        }
        double v1 = 0.5 * Math.sqrt(this.r * this.r + 2.0 * this.r + 1.0 + this.i * this.i);
        double v2 = 0.5 * Math.sqrt(this.r * this.r - 2.0 * this.r + 1.0 + this.i * this.i);
        return new Complex(Math.asin(v1 - v2), new Complex(this.i, -this.r).csgn() * Math.log(v1 + v2 + Math.sqrt(Complex.sqr(v1 + v2) - 1.0)));
    }

    public final Complex acos() {
        if (this.i == 0.0) {
            if (this.r < -1.0 || this.r > 1.0) {
                double v1 = 0.5 * Math.sqrt(this.r * this.r + 2.0 * this.r + 1.0);
                double v2 = 0.5 * Math.sqrt(this.r * this.r - 2.0 * this.r + 1.0);
                return new Complex(1.5707963267948966, -new Complex(this.i, -this.r).csgn() * Math.log(v1 + v2 + Math.sqrt(Complex.sqr(v1 + v2) - 1.0)));
            }
            return new Complex(Math.acos(this.r), 0.0);
        }
        double v1 = 0.5 * Math.sqrt(this.r * this.r + 2.0 * this.r + 1.0 + this.i * this.i);
        double v2 = 0.5 * Math.sqrt(this.r * this.r - 2.0 * this.r + 1.0 + this.i * this.i);
        return new Complex(Math.acos(v1 - v2), -new Complex(this.i, -this.r).csgn() * Math.log(v1 + v2 + Math.sqrt(Complex.sqr(v1 + v2) - 1.0)));
    }

    public final Complex atan() {
        if (this.r == 0.0) {
            if (this.i == 1.0) {
                return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
            }
            if (this.i == -1.0) {
                return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
            }
            if (this.i <= -1.0 || this.i >= 1.0) {
                return new Complex((Complex.isPositiveZero(this.r) ? 1.0 : -1.0) * 1.5707963267948966, 0.25 * Math.log(Complex.sqr(this.i + 1.0) / Complex.sqr(this.i - 1.0)));
            }
            return new Complex(0.0, 0.25 * Math.log(Complex.sqr(this.i + 1.0) / Complex.sqr(this.i - 1.0)));
        }
        return new Complex(0.5 * (Math.atan2(this.r, 1.0 - this.i) - Math.atan2(-this.r, this.i + 1.0)), 0.25 * Math.log((this.r * this.r + Complex.sqr(this.i + 1.0)) / (this.r * this.r + Complex.sqr(this.i - 1.0))));
    }

    public final Complex asec() {
        if (this.r == 0.0 && this.i == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (this.i == 0.0) {
            double c = 0.5 * Math.abs((this.r + 1.0) / this.r);
            double d = 0.5 * Math.abs((this.r - 1.0) / this.r);
            if (this.r > -1.0 && this.r < 0.0) {
                return new Complex(Math.PI, new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
            }
            if (this.r > 0.0 && this.r < 1.0) {
                return new Complex(0.0, new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
            }
            return new Complex(Math.acos(1.0 / this.r), new Complex(this.i, this.r).csgn() * 0.0);
        }
        double a = Complex.sqr(this.i / this.abs2());
        double b = this.r / this.abs2();
        double c = 0.5 * Math.sqrt(Complex.sqr(b + 1.0) + a);
        double d = 0.5 * Math.sqrt(Complex.sqr(b - 1.0) + a);
        return new Complex(Math.acos(c - d), new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
    }

    public final Complex acsc() {
        if (this.r == 0.0 && this.i == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (this.i == 0.0) {
            double c = 0.5 * Math.abs((this.r + 1.0) / this.r);
            double d = 0.5 * Math.abs((this.r - 1.0) / this.r);
            if (this.r > -1.0 && this.r < 0.0) {
                return new Complex(-1.5707963267948966, -new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
            }
            if (this.r > 0.0 && this.r < 1.0) {
                return new Complex(1.5707963267948966, -new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
            }
            return new Complex(Math.asin(1.0 / this.r), -new Complex(this.i, this.r).csgn() * 0.0);
        }
        double a = Complex.sqr(this.i / this.abs2());
        double b = this.r / this.abs2();
        double c = 0.5 * Math.sqrt(Complex.sqr(b + 1.0) + a);
        double d = 0.5 * Math.sqrt(Complex.sqr(b - 1.0) + a);
        return new Complex(Math.asin(c - d), -new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)));
    }

    public final Complex acot() {
        if (this.r == 0.0) {
            if (this.i == 1.0) {
                return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
            }
            if (this.i == -1.0) {
                return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
            }
            if (this.i <= -1.0 || this.i >= 1.0) {
                return new Complex(Complex.sign(this.r) == 1.0 ? 0.0 : Math.PI, -0.25 * Math.log(Complex.sqr(this.i + 1.0) / Complex.sqr(this.i - 1.0)));
            }
            return new Complex(1.5707963267948966, -0.25 * Math.log(Complex.sqr(this.i + 1.0) / Complex.sqr(this.i - 1.0)));
        }
        return new Complex(0.5 * (Math.PI - Math.atan2(this.r, 1.0 - this.i) + Math.atan2(-this.r, this.i + 1.0)), -0.25 * Math.log((this.r * this.r + Complex.sqr(this.i + 1.0)) / (this.r * this.r + Complex.sqr(this.i - 1.0))));
    }

    public final Complex asinh() {
        if (this.r == 0.0) {
            if (this.i < -1.0 || this.i > 1.0) {
                return new Complex(this.csgn() * Math.log(Math.abs(this.i) + Math.sqrt(this.i * this.i - 1.0)), 1.5707963267948966 * Complex.sign(this.i));
            }
            return new Complex(this.r, Math.asin(this.i));
        }
        double a = 0.5 * Math.sqrt(this.r * this.r + this.i * this.i + 2.0 * this.i + 1.0);
        double b = 0.5 * Math.sqrt(this.r * this.r + this.i * this.i - 2.0 * this.i + 1.0);
        return new Complex(this.csgn() * Math.log(a + b + Math.sqrt(Complex.sqr(a + b) - 1.0)), Math.asin(a - b));
    }

    public final Complex acosh() {
        if (this.i == 0.0) {
            double a = 0.5 * Math.abs(this.r + 1.0);
            double b = 0.5 * Math.abs(this.r - 1.0);
            if (this.r <= -1.0) {
                return new Complex(new Complex(this.i, 1.0 - this.r).csgn() * new Complex(this.i, -this.r).csgn() * Math.log(Math.abs(this.r) + Math.sqrt(this.r * this.r - 1.0)), Complex.sign(this.i) * Math.PI);
            }
            if (this.r < 1.0) {
                return new Complex(0.0, new Complex(this.i, 1.0 - this.r).csgn() * Math.acos(a - b));
            }
            return new Complex(new Complex(this.i, 1.0 - this.r).csgn() * new Complex(this.i, -this.r).csgn() * Math.log(Math.abs(this.r) + Math.sqrt(this.r * this.r - 1.0)), new Complex(this.i, 1.0 - this.r).csgn() * Math.acos(a - b));
        }
        double a = 0.5 * Math.sqrt(this.r * this.r + 2.0 * this.r + 1.0 + this.i * this.i);
        double b = 0.5 * Math.sqrt(this.r * this.r - 2.0 * this.r + 1.0 + this.i * this.i);
        return new Complex(new Complex(this.i, 1.0 - this.r).csgn() * new Complex(this.i, -this.r).csgn() * Math.log(a + b + Math.sqrt(Complex.sqr(a + b) - 1.0)), new Complex(this.i, 1.0 - this.r).csgn() * Math.acos(a - b));
    }

    public final Complex atanh() {
        if (this.i == 0.0) {
            if (this.r == -1.0) {
                return new Complex(Double.NEGATIVE_INFINITY, Double.NaN);
            }
            if (this.r == 1.0) {
                return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
            }
            if (this.r < -1.0 || this.r > 1.0) {
                return new Complex(0.25 * Math.log(Complex.sqr(this.r + 1.0) / Complex.sqr(this.r - 1.0)), Complex.sign(this.i) * 1.5707963267948966);
            }
            return new Complex(0.25 * Math.log(Complex.sqr(this.r + 1.0) / Complex.sqr(this.r - 1.0)), 0.5 * (Math.atan2(this.i, 1.0 + this.r) - Math.atan2(-this.i, 1.0 - this.r)));
        }
        return new Complex(0.25 * Math.log((this.i * this.i + Complex.sqr(this.r + 1.0)) / (this.i * this.i + Complex.sqr(this.r - 1.0))), 0.5 * (Math.atan2(this.i, 1.0 + this.r) - Math.atan2(-this.i, 1.0 - this.r)));
    }

    public final Complex asech() {
        if (this.i == 0.0) {
            double c = 0.5 * Math.abs((1.0 + this.r) / this.r);
            double d = 0.5 * Math.abs((1.0 - this.r) / this.r);
            if (this.r < -1.0 || this.r > 1.0) {
                return new Complex(0.0, new Complex(-this.i, this.r * this.r - this.r).csgn() * Math.acos(c - d));
            }
            if (this.r == 0.0) {
                return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
            }
            if (this.r < 0.0) {
                return new Complex(-new Complex(-this.i, -this.r + this.r * this.r).csgn() * new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)), -Complex.sign(this.i) * Math.PI);
            }
            return new Complex(-new Complex(-this.i, -this.r + this.r * this.r).csgn() * new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)), -this.i);
        }
        double a = this.r / this.abs2();
        double b = Complex.sqr(this.i / this.abs2());
        double c = 0.5 * Math.sqrt(Complex.sqr(a + 1.0) + b);
        double d = 0.5 * Math.sqrt(Complex.sqr(a - 1.0) + b);
        return new Complex(-new Complex(-this.i, -this.r + this.r * this.r + this.i * this.i).csgn() * new Complex(this.i, this.r).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)), new Complex(-this.i, this.r * this.r - this.r + this.i * this.i).csgn() * Math.acos(c - d));
    }

    public final Complex acsch() {
        if (this.r == 0.0) {
            double c = 0.5 * Math.abs((1.0 - this.i) / this.i);
            double d = 0.5 * Math.abs((1.0 + this.i) / this.i);
            if (this.i == 0.0) {
                return new Complex(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            }
            if (this.i > -1.0 && this.i < 1.0) {
                return new Complex(new Complex(this.r, -this.i).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)), -Complex.sign(this.i) * 1.5707963267948966);
            }
            return new Complex(Complex.sign(this.r) * 0.0, Math.asin(c - d));
        }
        double a = Complex.sqr(this.r / this.abs2());
        double b = this.i / this.abs2();
        double c = 0.5 * Math.sqrt(Complex.sqr(b - 1.0) + a);
        double d = 0.5 * Math.sqrt(Complex.sqr(b + 1.0) + a);
        return new Complex(new Complex(this.r, -this.i).csgn() * Math.log(c + d + Math.sqrt(Complex.sqr(c + d) - 1.0)), Math.asin(c - d));
    }

    public final Complex acoth() {
        if (this.i == 0.0) {
            if (this.r == -1.0) {
                return new Complex(Double.NEGATIVE_INFINITY, Double.NaN);
            }
            if (this.r == 1.0) {
                return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
            }
            if (this.r > -1.0 && this.r < 1.0) {
                return new Complex(0.25 * Math.log(Complex.sqr(this.r + 1.0) / Complex.sqr(this.r - 1.0)), -Complex.sign(this.i) * 1.5707963267948966);
            }
            return new Complex(0.25 * Math.log(Complex.sqr(this.r + 1.0) / Complex.sqr(this.r - 1.0)), -Complex.sign(this.i) * 0.0);
        }
        return new Complex(0.25 * Math.log((this.i * this.i + Complex.sqr(this.r + 1.0)) / (this.i * this.i + Complex.sqr(this.r - 1.0))), 0.5 * (Math.atan2(this.i, 1.0 + this.r) - Math.atan2(this.i, this.r - 1.0)));
    }

    public final Complex ceil() {
        return new Complex(Math.ceil(this.r), Math.ceil(this.i));
    }

    public final Complex floor() {
        return new Complex(Math.floor(this.r), Math.floor(this.i));
    }

    public final Complex rint() {
        return new Complex(Math.rint(this.r), Math.rint(this.i));
    }
}

