.PS
# selected from:
# https://tex.stackexchange.com/questions/129274/showcase-of-optical-illusions-made-with-tex-latex-luatex-context
# https://michaelbach.de/ot/
# Try the following (assuming m4 and Circuit_macros have been installed):
# m4 svg.m4 illusions.m4 | dpic -v > illusions.svg
# View the result in a browser.

gen_init
NeedDpicTools
maxpsht = 30
maxpswid = 10

# Circles
A: [
  bwid = 3/25.4
  bht = bwid
  box colored "grey" wid 12cm__ ht 12cm__ at (0,0)
  twist = 12
  foreach_(`n',
   `r = 6 - m4Lx
    for m=1 to n by 2 do {
      Point_(360/n*m+twist)
      rotbox(bwid,bht,outlined "white") at (Rect_(r/2.54,360/n*m))
      }
    for m=2 to n by 2 do {
      Point_(360/n*m+twist)
      rotbox(bwid,bht,outlined "black") at (Rect_(r/2.54,360/n*m))
      }
    twist = -twist ',
    70,56,42,28)
  ]

# OpArt
B: [
  linethick = 2
  refsize = 0.9
  dsep = refsize/12
  
  define qbox { [ # size, R
    if "$2"=="" then { define mx {} } else { define mx {-} }
    nlines = int($1/dsep)
    if "$2"=="" then { SW: (0,0) } else { SW: (0,-nlines*dsep) }
    { box wid $1 ht $1 invis fill 1 with .sw at SW }
    for i=0 to nlines do { line outline "darkgray" \
      from (i*dsep,0) to ( nlines*dsep, mx (nlines-i)*dsep)
    if i > 0 then { line outline "darkgray" \
      from (0,mx i*dsep) to ((nlines-i)*dsep,mx nlines*dsep) }
      } ] }
  
  B: qbox(refsize*(3+4/3),R)
  for i=1 to 3 do {
    for j=1 to 3 do {
      qbox(refsize) with .nw \
        at B.nw+ ((4*(j-1)+1)/3*refsize,-(4*(i-1)+1)/3*refsize)
      qbox(refsize/3,R) at last []
      }
    }
  ] with .nw at A.ne+(0.5,0)

# Parallel illusion
C: [
  boxwid = 1/2
  boxht = 1/2
  nrows = 9
  ncols = 11
  gap = scale/72

  Background: box color "gray" wid (ncols+0.5)*boxwid \
    ht nrows*boxht + (nrows-1)*gap
  move to Background.nw+(0,-boxht/2)
  h = 1; dh = -1
  for i=1 to nrows do {
    { move right h * boxwid/4
      for j=1 to ncols do { box thick 0 fill (j+1)%2 } }
    move down boxht+gap
    h += dh ; if (h==0 || h==2) then { dh = -dh }
    }
  ] with .nw at A.sw+(0,-0.5)

# Blue illusion
  gap = 1.5mm__ ; bheight = 2 ; bwidth = bheight/2; aradius = bheight/5
D:[
  define(`leftblue',`0,0,0.55')
  define(`rightblue',`0.16,0.16,0.84')
  rgbtohsv(leftblue,hl,sl,vl)
  rgbtohsv(rightblue,hr,sr,vr)
  hsvtorgb((hl+hr)/2,(sl+sr)/2,(vl+vr)/2,rc,gc,bc)
  define(`centerblue',`rc,gc,bc')
T: [
  box wid bwidth ht bheight colored rgbstring(leftblue)
  box wid bwidth ht bheight colored rgbstring(rightblue)
  circle rad aradius thick aradius/(1bp__) at last box.w \
   outlined rgbstring(centerblue) ]
M: [
  box wid bwidth ht bheight colored rgbstring(leftblue)
  box wid bwidth ht bheight colored rgbstring(rightblue)
  circle rad aradius thick aradius/(1bp__) at last box.w-(gap/2,0) \
   outlined rgbstring(centerblue)
  line outlined "white" thick gap/(1bp__) from last box.nw-(gap/2,0) \
    down bheight ] with .nw at T.sw+(0,-gap)
L: [
  C: box wid bwidth ht bheight colored rgbstring(leftblue)
  D: box wid bwidth ht bheight colored rgbstring(rightblue) \
    with .nw at (C.e.x,C.n.y-bheight/5)
  arc thick aradius/(1bp__) outlined rgbstring(centerblue) \
    from C.e+(0,aradius) to C.e-(0,aradius) with .c at C.e
  arc cw thick aradius/(1bp__) outlined rgbstring(centerblue) \
    from D.w+(0,aradius) to D.w-(0,aradius) with .c at D.w
  ] with .nw at M.sw+(0,-gap)
 ] with .nw at C.ne+(0.5,1)

# Ebbinghaus
E: [ L: circle diam 0.8 colored "orange"
     for i=0 to 5 do { circle diam 1.6 colored rgbstring(0.68,0.85,0.9) \
       at L+(Rect_(1.7,i*60)) } 
     R: circle diam 0.8 colored "orange" at L+(4,0)
     for i=0 to 7 do { circle diam 0.4 colored rgbstring(0.68,0.85,0.9) \
       at R+(Rect_(0.7,i*360/8)) }
  ] scaled 0.75 with .nw at C.sw+(0,-0.5)

# Grid
F: [ gwid = 5; bxw = 0.9/9.5*gwid; gap = (gwid - bxw*8)/9
    B: box wid gwid ht gwid colored "gray"
    for i=0 to 7 do {
      for j=0 to 7 do { box wid bxw ht bxw fill_(0) \
        at B.nw + (gap+bxw/2+j*(bxw+gap),-(gap+bxw/2 + i*(bxw+gap))) } }
    for i=1 to 7 do {
      for j=1 to 7 do { circle rad gap/sqrt(2) colored "white" \
        at B.nw+((gap+bxw)*j+gap/2,-((gap+bxw)*i+gap/2)) } }
     ] with .nw at E.sw+(0,-0.5)

#White
G: [ linethick = 0.25/(1bp__)
    line thick linethick*2 outlined "gray" down lthick*5 from (2,-lthick*3)
    for i=1 to 5 do { line right 2.8 from (0, -((i-1)*2+1/2)*lthick) }
    for i=2 to 6 by 2 do { line outline "gray" right lthick*2 \
      from (0.75,-((1/2+i)*linethick bp__)) }
     ] with .nw at F.ne+(0.5,0)

# Escher1
H: [ t = 0.25; w = 2.25; h = 0.6
     T: line right w then down h then left w-t*2 then down t left t \
       then right w then up h+2*t then left w then down t left t \
       shaded graystring(0.9)
     U: line right w then down t left t then left w-t*2 then down h \
       then right w then down t left t then left w then up h+2*t \
       shaded graystring(0.7)
     V: line from Here+(t,-t) right t then down h-t then down t left t \
       then up h shaded graystring(0.5)
     W: line from Here+(w-t*2,0) down h-t then right t then up h \
       then down t left t shaded graystring(0.5)
     ] with .nw at F.sw+(0,-0.5)

# Escher2
I: [ t = 0.25; w = 2.25
     P1: Here
     P2: P1+(t,0)
     P3: P2+(Rect_(w,-60))+(Rect_(t,-120))
     P4: P3+(-w,0)+(Rect_(t,120))
     P5: P2+(Rect_(t,-60))+(Rect_(t,-120))
     P6: P4+(Rect_(t,60))+(t,0)
     P7: P3+(-t,0)+(Rect_(t,120))
     line from P1 to P2 to P6 to P7+(Rect_(t,120)) to P7 to P4 to P1 \
       shaded graystring(0.9)
     line from P2 to P2+(Rect_(w,-60)) to P3 to P5 to P6+(t,0) to P6 to P2 \
       shaded graystring(0.8)
     line from P5 to P3 to P3+(-w,0) to P4 to P7 to P5+(Rect_(t,-120)) \
       shaded graystring(0.6)
     ] with .nw at H.ne

# Curved grid
J: [ t = 0.1; r = t*6
    for i=0 to 2 do {
      for j=0 to 2 do {
        for k=1 to 6 do { C:circle outlined "gray" rad t*k at (j*2*r,(-i*2*r)) }
        line thick 1.2 outlined "red" from C+(r,0) to C+(0,-r) \
          then to C+(-r,0) then to C+(0,r) then to C+(r,0)  
        }}
     ] with .nw at H.sw+(0,-1)
.PE
